/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	pgpCache.h	- indexed data cache header
	

	$Id: pgpCache.h,v 1.1 1999/09/14 19:10:54 cpeterson Exp $
____________________________________________________________________________*/

#ifndef _pgpCache_h
#define _pgpCache_h

typedef struct _CACHEITEM {
	struct _CACHEITEM*	pitemNext;
	LONG				lSecondsRemaining;
	ULONG				ulIndexLength;
	UCHAR				ucIndex[kPGPUDMaxCacheIndexLength];
	ULONG				ulDataLength;
	UCHAR				ucData[kPGPUDMaxCacheDataLength];
} PGPCACHEITEM, *PPGPCACHEITEM;

typedef struct {
	PPGPCACHEITEM		pitemFirst;
} PGPCACHE, *PPGPCACHE;


VOID
pgpProcessCacheTimerEvent (
	IN PPGPCACHE		ppc,
	IN PVOID			pCriticalSection);

VOID
pgpInitCache (
	IN PPGPCACHE		ppc);

VOID
pgpCacheProcessOperation (
	IN PPGPCACHE		ppc,
	IN PPGPCACHESTRUCT	ppcs,
	IN PVOID			pCriticalSection);

#endif //_pgpCache_h